<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))" />
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <title lang="en">Výpis Základní staničení</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <h2 lang="en">SVýpis Základní staničení</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>

                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@name"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Popis:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@description"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Základní (Aktivní) trasa:</th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="HorizontalAlignment/@name"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@file"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Poslední úprava:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">Koeficient vstupního rastru:&#xa0; </th>
                                            <td align="left" style="font-size: 80%">
                                                <xsl:value-of select="../@inputGridScaleFactor" />
                                            </td>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Poznámka:&#xa0; </strong>Všechny jednotky tohoto výpisu jsou
                                                <xsl:if test="//@linearUnits = 'Imperial'">ve stopách, </xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">v metrech, </xsl:if>
                                                pokud není specifikováno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>

                                <xsl:for-each select="*/StationOffsetPoints">
                                    <table class="margin" cellpadding="2" width="100%">
                                        <thead>
                                            <tr>
                                                <th colspan="4" lang="en">- - - - - - - - Základní trasa  - - - - - - -</th>
                                                <th>&#xa0;</th>
                                                <th colspan="4" lang="en">- - - - - - - - Odstup trasa - - - - - - - -</th>
                                            </tr>
                                            <tr>
                                                <th class="underline" lang="en" valign="bottom">Staničení</th>
                                                <th class="underline" lang="en" valign="bottom">Typ</th>
                                                <th class="underline" lang="en">
                                                    Vzdálenost k<br />Odstup Bod
                                                </th>
                                                <th class="underline" lang="en" valign="bottom">Radiální směr</th>
                                                <th>&#xa0;</th>
                                                <th class="underline" lang="en" valign="bottom">Staničení</th>
                                                <th class="underline" lang="en" valign="bottom">Typ</th>
                                                <th class="underline" lang="en">
                                                    Vzdálenost <br />Odstup Bod
                                                </th>
                                                <th class="underline" lang="en" valign="bottom">Radiální Směr</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <xsl:for-each select="StationOffsetPoint">
                                                <xsl:if test="not(@offsetAlignmentName = preceding-sibling::*/@offsetAlignmentName)">
                                                    <tr>
                                                        <td colspan="7" lang="en">
                                                            <strong>
                                                                <br/>Odstup (Definovaný) Trasa: &#xa0;
                                                            </strong>
                                                            <xsl:value-of select="@offsetAlignmentName"/>
                                                            <br/>
                                                        </td>
                                                    </tr>
                                                </xsl:if>
                                                <tr>
                                                    <td align="right">
                                                        <xsl:value-of select="cif:stationFormat(number(centerLinePoint/point/station/@externalStation), string(centerLinePoint/point/station/@externalStationName))"/>
                                                    </td>
                                                    <td align="right">
                                                        <xsl:value-of select="centerLinePoint/point/@type"/>
                                                    </td>
                                                    <td align="right">
                                                        <xsl:value-of select="cif:distanceFormat(number(@secondOffset))"/>
                                                    </td>
                                                    <td align="right">
                                                        <xsl:value-of select="cif:directionFormat(number(centerLinePoint/@radialDirection))"/>
                                                    </td>
                                                    <td>&#xa0;</td>
                                                    <td align="right">
                                                        <xsl:value-of select="cif:stationFormat(number(offsetLinePoint/point/station/@externalStation), string(offsetLinePoint/point/station/@externalStationName))"/>
                                                    </td>
                                                    <td align="right">
                                                        <xsl:value-of select="offsetLinePoint/point/@type"/>
                                                    </td>
                                                    <td align="right">
                                                        <xsl:value-of select="cif:distanceFormat(number(@firstOffset))"/>
                                                    </td>
                                                    <td align="right">
                                                        <xsl:value-of select="cif:directionFormat(number(offsetLinePoint/@radialDirection))"/>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </xsl:for-each>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>

    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Pro tento výpis musíte vytvořit body ve staničení a odstupu pomocí 
                <em> Nástroje &gt; XML Výpisy &gt; Základní staničení</em>.
            </p>
            <p class="normal1" lang="en">
                Musíte vybrat nejméně jedno směrové řešení nebo jeden prvek v listu <em>Obecně</em>, v poli <em>Z</em>.
            </p>
            <p class="normal1" lang="en">
                Musíte také vybrat nejméně jedno směrové řešení v listu <em>Směrová řešení</em> nebo prvek v listu <em>Prvky</em>.
            </p>
            <p class="normal1" lang="en">
                Musíte vybrat nejméně jednu volbu v listu <em>Zahrnout</em> (<em>
                    Směrové body - Na trase, Významné, 
					Výškové body - Na trase, Významné
                </em> nebo <em>Interval</em>.)
            </p>
            <p class="normal1" lang="en">
                <em>Staničení Limity</em>použijte pouze na spočtená data, např. body pomocí Interval.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2013 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
